#changes needed after April 2025 data update, these will be incorporated in future release, just need a fast way to run analysis for deadline
#adds time.at.den.range for truncating that part of the simulation (was hard coded 2 to 23, 
#  but Eric's data are .5 to 22.5)
#changes around lines 137 and 140 

den.func.parallel.remand=function(den.hab=den_pts,
                           emerge.param    = emergence.param$par,
                           birth.dates     = c(334,379),
                           entrance.dates  = c(mean.ent,sd.ent),
                           littersize      = ls.prop,
                           time.at.den     = c(mean.tad,sd.tad),
                           time.at.den.range = c(.5,22.5),
                           n.dens.1002     = c(14^2/6.3^2,14/6.3^2),
                           n.dens.cc       = c(26^2/9.5^2,26/9.5^2),
                           n.dens.npra     = c(12^2/5.8^2,12/5.8^2),
                           n.dens.other    = c(15.1^2/7^2,15.1/7^2),
                           prop.barrier.cc = 22/37,
                           prop.infrastructure.cc=.25,
                           prop.other      = c(0.0645,0.3226,.6129), 
                           n.total.cc      = 37,
                           n.total.other   = 15, 
                           emerg.year      = 2023,
                           infra.dist      = 5000){
  
  #Required packages
  require(raster)
  require(spatstat)
  require(ald)
  require(truncnorm)
  
  
  
  ##############
  #Den Location#
  ##############
  #Simulate number of dens in NPRA, CC, and 1002
  n.npra        = ceiling(rgamma(1,n.dens.npra[1] ,n.dens.npra[2] ))
  n.1002        = ceiling(rgamma(1,n.dens.1002[1] ,n.dens.1002[2] ))
  n.cc          = ceiling(rgamma(1,n.dens.cc[1]   ,n.dens.cc[2]   ))
  n.Patil.other = ceiling(rgamma(1,n.dens.other[1],n.dens.other[2]))
  
  #break Patil's definition of other into ANWR_non1002 and our definition of Other using empirical proportions from the den catalog
  p.other = rmultinom(1,n.total.other,prop.other)/n.total.other
  n.non1002 =  round(n.Patil.other*p.other[2])     #assign to largest group first, then smaller ones
  n.Other = n.Patil.other - n.non1002 - round(n.Patil.other*p.other[3])  #gets what left after removing non1002 and the larger proportion that doesn't apply to land dens
  
  #break cc into barrier island and mainland
  p.cc.barrier = rbinom(1,n.total.cc,prop.barrier.cc)/n.total.cc     
  n.cc.barrier = round(n.cc*p.cc.barrier)
  n.cc.mainland.both = n.cc-n.cc.barrier
  
  #break mainland into within XXX km of infrastructure and rest
  n.cc.infrastructure = rbinom(1,n.cc.mainland.both,prop.infrastructure.cc) #can shortcut because above is not based on a fixed number n.cc.mainland
  n.cc.mainland = n.cc.mainland.both-n.cc.infrastructure   #note this redefines n.cc.mainland to outside the infrastructure,
  
  # do a check in case someone puts in a different value for infra.dist
  if (infra.dist != 5000) print("WARNING!!! you have supplied infra.dist other than 5000, usual input den points assimed infra.dist=5000, make sure to change things appropriately if you wish to use a different value")
  
  #Simulate den location on Durner den habitat based on relative probability from underlying UD    ####19OCT2023 includes complete SBS land IFSAR data
  
  #more generalized way of adding dens when some are potentially zero is to make a list of the indices and pull them all at once at the end
  
  tmp.samp.npra  =  sample(which(den.hab$sel.NPRA), n.npra, prob=den.hab[den.hab$sel.NPRA,'rel_prob'], replace=F)  #sample appropriate index numbers according to rel_prob
  dens.list = tmp.samp.npra
  
  tmp.samp.cc.barrier = sample(which(den.hab$sel.CC.barrier), n.cc.barrier, prob=den.hab[den.hab$sel.CC.barrier,'rel_prob'], replace=F)  
  dens.list = c(dens.list,tmp.samp.cc.barrier )
  
  tmp.samp.1002  =  sample(which(den.hab$sel.ANWR.1002), n.1002, prob=den.hab[den.hab$sel.ANWR.1002,'rel_prob'], replace=F)  
  dens.list = c(dens.list,tmp.samp.1002 )
  
  if(n.non1002>0){#no need to do if zero points
    tmp.samp.non1002 =  sample(which(den.hab$sel.ANWR.non1002), n.non1002, prob=den.hab[den.hab$sel.ANWR.non1002,'rel_prob'], replace=F)  
    dens.list = c(dens.list,tmp.samp.non1002 )
    
  }
  if(n.Other>0){#no need to do if zero points
    tmp.samp.Other = sample(which(den.hab$sel.Patil.other), n.Other, prob=den.hab[den.hab$sel.Patil.other,'rel_prob'], replace=F)  
    dens.list = c(dens.list,tmp.samp.Other )
  }  
  if(n.cc.mainland>0){#no need to do if zero points elsewhere in CC (all near infrastructure, which happens on rare occasions)
    tmp.samp.cc.main = sample(which(den.hab$sel.CC.mainland.noinf), n.cc.mainland, prob=den.hab[den.hab$sel.CC.mainland.noinf,'rel_prob'], replace=F)  
    dens.list = c(dens.list,tmp.samp.cc.main)
  }
  
  if(n.cc.infrastructure>0){#no need to do if zero points near infrastructure
    tmp.samp.cc.infr = sample(which(den.hab$sel.CC.mainland.inf), n.cc.infrastructure, prob=den.hab[den.hab$sel.CC.mainland.inf,'rel_prob'], replace=F)  
    dens.list = c(dens.list,tmp.samp.cc.infr )
  }
  
  
  sim.dens = den.hab[dens.list,]  #pick all the accumulated indices
  n.dens= n.npra + n.1002 + n.cc.barrier + n.cc.mainland + n.cc.infrastructure + n.non1002 + n.Other
  
  ################
  #Den attributes#
  ################
  
  #Assign entrance dates informed from empirical distribution of entrance dates
  sim.dens$entrance.jd   = round(rtruncnorm(n.dens,a=254,b=356,mean = mean.ent,sd =sd.ent )) #restrict to fall between min/max entrance from empirical data (12Sep, 22Dec)
  sim.dens$entrance.date = (strptime(paste0('01-01-',emerg.year),'%m-%d-%Y') + sim.dens$entrance.jd*(24*3600)) - 365*24*3600#Ensure the year is y-1 from emergence year
  
  #Assign cub birth dates from 1Dec-15Jan 
  #Need to ensure birth does not occur prior to den entrance.  
  sim.dens$birth.date=NA                                                    #is this really necessary anymore?  only accomplishes order of varibales in resulting matrix
  sim.dens$birth.jd   = round(rtruncnorm(n.dens,a=pmax(sim.dens$entrance.jd,334), b=379, mean = 348,sd =10 ))  #restrict: a=max(junk.entrance,birth.dates[1]), b=birth.dates[2]
  sim.dens$birth.date = strptime(paste0('01-01-',emerg.year-1),'%m-%d-%Y') + sim.dens$birth.jd*24*3600  
  sim.dens[sim.dens$birth.jd >= birth.dates[1],'birth.date'] = (strptime(paste0('01-01-',emerg.year-1),'%m-%d-%Y') + sim.dens[sim.dens$birth.jd >= birth.dates[1],'birth.jd']*(24*3600))#-366*24*3600 #fix any that had end of year calculation issues
  
  
  #Determine the date 60d after birth
  sim.dens$age.60d    = sim.dens$birth.date+60*24*3600
  sim.dens$age.60d.jd = strptime(sim.dens$age.60d,'%Y-%m-%d')$yd
  
  #Assign litter size
  ls = rmultinom(1,n.dens,littersize)
  ls = c(rep(0,ls[1]),rep(1,ls[2]),rep(2,ls[3]),rep(3,ls[4]))
  sim.dens$littersize = sample(ls,length(ls),replace=F)
  
  #Assign desired emergence dates for simulated dens from asymetric laplace dist. with param
  #derived from empirical emergent dates
  #Restrict to >=1 day after 60d age of cubs, falls between min/max emergence (9Jan, 9Apr)
  sim.dens$emerge.jd = rALD(nrow(sim.dens),emerge.param[1],emerge.param[2],emerge.param[3])
  tmp.fix.index = which(sim.dens$emerge.jd < 8 | sim.dens$emerge.jd > 99 | sim.dens$emerge.jd <= (sim.dens$age.60d.jd + 1) ) #check which values might need to be fixed
  while(length(tmp.fix.index)>0){
    sim.dens$emerge.jd[tmp.fix.index] = rALD(length(tmp.fix.index),emerge.param[1],emerge.param[2],emerge.param[3])         #fix the bad ones
    tmp.fix.index = which(sim.dens$emerge.jd < 8 | sim.dens$emerge.jd > 99 | sim.dens$emerge.jd <= (sim.dens$age.60d.jd + 1) ) #reevaluate
  }
  sim.dens$emerge.date = strptime(paste0('01-01-',emerg.year),'%m-%d-%Y') + sim.dens$emerge.jd*(24*3600)
  
  
  #Determine desired number of days spent in den
  sim.dens$time.in.den = (sim.dens$emerge.jd+365) - sim.dens$entrance.jd  
  
  #Assign time at den post-emergence, pre-departure: truncate to be within the observed values
  sim.dens$time.at.den = ceiling(rgamma(n.dens,time.at.den[1]^2/time.at.den[2]^2,time.at.den[1]/time.at.den[2]^2))
  tmp.fix.index = which(sim.dens$time.at.den < time.at.den.range[1] | sim.dens$time.at.den > time.at.den.range[2] ) #check which values might need to be fixed
  while(length(tmp.fix.index)>0){
    sim.dens$time.at.den[tmp.fix.index] = ceiling(rgamma(length(tmp.fix.index),time.at.den[1]^2/time.at.den[2]^2,time.at.den[1]/time.at.den[2]^2))
    tmp.fix.index = which(sim.dens$time.at.den < time.at.den.range[1] | sim.dens$time.at.den > time.at.den.range[2] ) #reevaluate
  }
  sim.dens$departure.date = sim.dens$emerge.date + sim.dens$time.at.den*24*3600
  
  #Assign den snow depth based on data in Durner et al. 2004
  sim.dens$depth = rgamma(n.dens,72^2/87^2,72/87^2)
  
  return(sim.dens)
  
}
